.H 1 "Signals Window"
This window controls the delivery of Unix signals to the process.
From the window signals can be sent to the process or
signals sent from other sources may be intercepted.
The window cannot be opened for core dumps.
.P
When a signal is sent to a process that is running under the control
of a debugger, the Unix operating system gives the debugger the opportunity
to intercept and cancel the signal before the target process receives it.
The Signals window allows you modify the set of signals that are
intercepted and traced by the debugger.
Signals that are not in the traced set, bypass the debugger and are
sent directly to the target process.
.P
When pi intercepts a signal that is being traced for a process,
the process is suspended and a message of the form:
.DS I N
EVENT PENDING: signal name
.DE
.P
is placed on the status line of the Process window.
At this point you have the option to either send the signal to the
process or cancel it.
To cancel it, use the "clear pending signal" entry 
in the Signals window's menu bar.
To send the signal, just continue the execution of the process.
.H 2 "Signals Layout"
The title bar lists the process id number.
Lines within the window display signal names and
are ordered by signal number.
Signals that are being traced start with the characters ">>>".
.P
By default, the following signals are traced:
SIGINT, SIGILL, SIGTRAP, SIGIOT, SIGEMT, SIGFPE, SIGBUS, SIGSEGV,
SIGSYS, SIGPIPE, and SIGSTOP.
SIGTRAP and SIGSTOP are used by the debugger and
must be traced for pi to operate correctly.
It is impossible to trace SIGKILL, as the operating system does not
allow this signal to be intercepted by the debugger and it always
kills the process.
.P
If the operating systems supports a debugging primitive that
suspends an exec() system call before the first instruction of
the new program is executed,
the Signals window allows you to toggle this option.
This stop-on-exec feature is supported in pi with versions of the Unix
operating system that have mounted processes, and in rtpi with targets
running NRTX.
When present, the bottom line in the window displays ">>> exec()"
when the option is configured to stop the process if it calls exec(), and
"exec()" if it is configured to execute the exec() at full speed.
The line's menu toggles the setting.
.H 2 "Signals Menu Bar"
The "signals" menu contains the following entries:
.VL 3 1
.LI "clear pending signal"
.br
Clear the signal that is pending for the process.
This entry should be used when the status line in the Process
window displays a line of the form:
.DS I N
EVENT PENDING: signal name
.DE
.P
and you don't want the signal to be sent to the process when it is resumed.
.LI "clear pending signal and go"
.br
Clear the signal that is pending for the process and start it executing.
This is equivalent to selecting "clear pending signal" and then
"run" in the Process window's "stmt" menu.
.LE
.H 2 "Signals Line Menus"
.VL 14 1
.LI "trace on|off"
Toggle tracing of the signal.
If the line starts with the character sequence ">>>" the signal is
currently being traced and the menu entry lets you turn tracing off.
Otherwise the signal is not being traced and the entry lets you
turn tracing on.
.LI "send signal"
Send the selected signal to the process. 
.LE
.P
If the operating system supports the stop-on-exec option
the bottom line in the window is:
.DS I N
[>>>] exec()
.DE
.P
and its line menu contains one of the following:
.VL 8 1
.LI "hang"
Set the stop-on-exec flag so if the process calls the exec() system call,
it stops before the first instruction in the new program is executed.
.LI "clear"
Set the stop-on-exec flag so if the process calls the exec() system call,
the new program executes at full speed.
.LE
